/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ILivestock;
import net.dries007.tfc.api.util.IRidable;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.objects.entity.animal.EntityLlamaTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

@ParametersAreNonnullByDefault
public class EntityCamelTFC
extends EntityLlamaTFC
implements IAnimalTFC,
ILivestock,
IRidable {
    private static final DataParameter<Integer> DATA_COLOR_ID = EntityDataManager.func_187226_a(EntityCamelTFC.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HALTER = EntityDataManager.func_187226_a(EntityCamelTFC.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityCamelTFC(World world) {
        this(world, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityAnimalTFC.getRandomGrowth(ConfigTFC.Animals.CAMEL.adulthood, ConfigTFC.Animals.CAMEL.elder));
        this.func_70105_a(0.9f, 2.0f);
    }

    public EntityCamelTFC(World world, IAnimalTFC.Gender gender, int birthDay) {
        super(world, gender, birthDay);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    protected SoundEvent func_184639_G() {
        return Constants.RNG.nextInt(100) < 5 ? TFCSounds.ANIMAL_CAMEL_CRY : TFCSounds.ANIMAL_CAMEL_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TFCSounds.ANIMAL_CAMEL_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFCSounds.ANIMAL_CAMEL_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (!blockIn.func_176223_P().func_185904_a().func_76224_d()) {
            SoundType soundtype = blockIn.func_185467_w();
            if (this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150431_aC) {
                soundtype = Blocks.field_150431_aC.func_185467_w();
            }
            if (this.func_184207_aI() && this.field_190688_bE) {
                ++this.field_110285_bP;
                if (this.field_110285_bP > 5 && this.field_110285_bP % 3 == 0) {
                    this.func_190680_a(soundtype);
                } else if (this.field_110285_bP <= 5) {
                    this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
                }
            } else if (soundtype == SoundType.field_185848_a) {
                this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            } else {
                this.func_184185_a(SoundEvents.field_187729_cv, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            }
        }
    }

    public boolean func_190677_dK() {
        return true;
    }

    public boolean func_190682_f(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150404_cg);
    }

    public boolean func_190685_dA() {
        return true;
    }

    public void func_76316_a(IInventory invBasic) {
        EnumDyeColor enumdyecolor = this.func_190704_dO();
        super.func_76316_a(invBasic);
        EnumDyeColor enumdyecolor1 = this.func_190704_dO();
        if (this.field_70173_aa > 20 && enumdyecolor1 != null && enumdyecolor1 != enumdyecolor) {
            this.func_184185_a(SoundEvents.field_191257_dH, 0.5f, 1.0f);
        }
        boolean flag = this.func_110257_ck();
        this.func_110232_cE();
        if (this.field_70173_aa > 20 && !flag && this.func_110257_ck()) {
            this.func_184185_a(SoundEvents.field_187726_cu, 0.5f, 1.0f);
        }
    }

    protected void func_110232_cE() {
        if (!this.field_70170_p.field_72995_K) {
            super.func_110232_cE();
            this.setColorByItem(this.field_110296_bG.func_70301_a(1));
        }
    }

    @Nullable
    public EnumDyeColor func_190704_dO() {
        int i = (Integer)this.field_70180_af.func_187225_a(DATA_COLOR_ID);
        return i == -1 ? null : EnumDyeColor.func_176764_b((int)i);
    }

    private void setColor(@Nullable EnumDyeColor color) {
        this.field_70180_af.func_187227_b(DATA_COLOR_ID, (Object)(color == null ? -1 : color.func_176765_a()));
    }

    @Override
    public boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.canAcceptHalter(stack)) {
            return this.attemptApplyHalter((EntityAnimal)this, this.field_70170_p, player, stack);
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void onFertilized(@Nonnull IAnimalTFC male) {
        this.setPregnantTime(CalendarTFC.PLAYER_TIME.getTotalDays());
        int selection = this.field_70146_Z.nextInt(9);
        int i = selection < 4 ? this.func_190719_dM() : (selection < 8 ? ((EntityCamelTFC)male).func_190719_dM() : this.field_70146_Z.nextInt(4));
        this.geneVariant = i;
        EntityCamelTFC father = (EntityCamelTFC)male;
        this.geneHealth = (float)((father.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + (double)this.func_110267_cL()) / 3.0);
        this.geneSpeed = (float)((father.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.func_110203_cN()) / 3.0);
        this.geneJump = (float)((father.func_110148_a(field_110271_bv).func_111125_b() + this.func_110148_a(field_110271_bv).func_111125_b() + this.func_110245_cM()) / 3.0);
        this.geneStrength = this.field_70146_Z.nextInt(Math.max(this.func_190707_dL(), father.func_190707_dL())) + 1;
        if (this.field_70146_Z.nextFloat() < 0.03f) {
            this.geneStrength += 1.0f;
        }
    }

    @Override
    public int getDaysToAdulthood() {
        return ConfigTFC.Animals.CAMEL.adulthood;
    }

    @Override
    public int getDaysToElderly() {
        return ConfigTFC.Animals.CAMEL.elder;
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!(BiomesTFC.isOceanicBiome(biome) || BiomesTFC.isBeachBiome(biome) || biomeType != BiomeHelper.BiomeType.DESERT && biomeType != BiomeHelper.BiomeType.SAVANNA)) {
            return ConfigTFC.Animals.CAMEL.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.MALE_AND_FEMALES;
    }

    @Override
    public int getMinGroupSize() {
        return 1;
    }

    @Override
    public int getMaxGroupSize() {
        return 2;
    }

    @Override
    protected void func_110237_h(EntityPlayer player) {
        if (this.isHalter()) {
            super.func_110237_h(player);
        }
    }

    @Override
    public long gestationDays() {
        return ConfigTFC.Animals.CAMEL.gestation;
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Variant", this.func_190719_dM());
        nbt.func_74768_a("Strength", this.func_190707_dL());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            nbt.func_74782_a("DecorItem", (NBTBase)this.field_110296_bG.func_70301_a(1).func_77955_b(new NBTTagCompound()));
        }
        nbt.func_74757_a("halter", this.isHalter());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.func_190706_p(nbt.func_74762_e("Strength"));
        this.func_190710_o(nbt.func_74762_e("Variant"));
        if (nbt.func_150297_b("DecorItem", 10)) {
            this.field_110296_bG.func_70299_a(1, new ItemStack(nbt.func_74775_l("DecorItem")));
        }
        this.func_110232_cE();
        this.setHalter(nbt.func_74767_n("halter"));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_COLOR_ID, (Object)-1);
        this.func_184212_Q().func_187214_a(HALTER, (Object)false);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_CAMEL;
    }

    @Override
    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        EntityCamelTFC other = (EntityCamelTFC)otherAnimal;
        return this.getGender() != other.getGender() && this.func_70880_s() && other.func_70880_s();
    }

    @Nullable
    public EntityCamelTFC createChild(@Nonnull EntityAgeable other) {
        if (other != this && this.getGender() == IAnimalTFC.Gender.FEMALE && other instanceof IAnimalTFC) {
            super.setFertilized(true);
            this.func_70875_t();
            this.onFertilized((IAnimalTFC)other);
        } else if (other == this) {
            return new EntityCamelTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays());
        }
        return null;
    }

    @Override
    public void birthChildren() {
        int numberOfChildren = ConfigTFC.Animals.CAMEL.babies;
        for (int i = 0; i < numberOfChildren; ++i) {
            EntityCamelTFC baby = new EntityCamelTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays());
            baby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            if (this.geneHealth > 0.0f) {
                baby.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.geneHealth);
            }
            if (this.geneSpeed > 0.0f) {
                baby.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.geneSpeed);
            }
            if (this.geneJump > 0.0f) {
                baby.func_110148_a(field_110271_bv).func_111128_a((double)this.geneJump);
            }
            if (this.geneStrength > 0.0f) {
                this.func_190706_p((int)this.geneStrength);
            }
            baby.func_190710_o(this.geneVariant);
            this.field_70170_p.func_72838_d((Entity)baby);
        }
        this.geneJump = 0.0f;
        this.geneSpeed = 0.0f;
        this.geneJump = 0.0f;
        this.geneStrength = 0.0f;
        this.geneVariant = 0;
    }

    @Override
    public boolean isHalter() {
        return (Boolean)this.field_70180_af.func_187225_a(HALTER);
    }

    @Override
    public void setHalter(boolean value) {
        this.field_70180_af.func_187227_b(HALTER, (Object)value);
    }

    protected void func_190680_a(SoundType p_190680_1_) {
        this.func_184185_a(SoundEvents.field_187714_cq, p_190680_1_.func_185843_a() * 0.15f, p_190680_1_.func_185847_b());
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    private void setColorByItem(ItemStack stack) {
        if (this.func_190682_f(stack)) {
            this.setColor(EnumDyeColor.func_176764_b((int)stack.func_77960_j()));
        } else {
            this.setColor(null);
        }
    }
}

